import java.io.*;

public class File_handler
{
	public File_handler()
	{
		
	}
	
	/**
	 * Saving a game to file
	 * @param gameNumber - Which game to save
	 * @param game - All information about the game, that needs to be saved
	 **/
	
	public void saveGame(int gameNumber, GameInfo game)
	{
		try
		{
			// Opens connection
		
			DataOutputStream outStream = new DataOutputStream(new FileOutputStream("Game("+gameNumber+").sav"));
			
			// ------------ Writes data -------------
			
			outStream.writeInt(game.getNumberOfPlayers());			// Writes number of players
			
			for(int i = 0; i < game.getNumberOfPlayers(); i++)		
			{
				outStream.writeUTF(game.getPlayerNick(i));			// Writes playerNicks
				outStream.writeUTF(game.getPlayerPW(i));			// Writes playerPWs
			}
			
			// Writes history
			
			for(int i = 0; i < game.getNumberOfPlayers(); i++)		// For each player
				for(int i2 = 0; i2 < game.getNumberOfPlayers(); i2++) // For each player's enemy
					for(int i3 = 0; i3 < 2; i3++)						// For each history type
						outStream.writeInt(game.getHistory(i, i2, i3));
			
			// Writes current turn information
			
			for(int i = 0; i < game.getNumberOfPlayers(); i++)
				for(int i2 = 0; i2 < 17; i2++)
					outStream.writeInt(game.getCurrentTurnInformation(i, i2));
					
			// Writes orders
			
			for(int i = 0; i < game.getNumberOfPlayers(); i++)
				for (int i2 = 0; i2 < 3; i2++)
					outStream.writeInt(game.getOrder(i, i2));		
			
			outStream.close();
			
			System.out.println("When saving:");
			game.printGameInfo();
		}
		catch(Exception err)
		{
			
		}
	}
	
	/**
	 * Loads a game from file
	 * @param gameNumber - Index number of which game to load
	 * @return A GameInfo class file, which contains all game information
	 **/
	
	public GameInfo loadGame(int gameNumber) // Change to return GameInfo
	{
		GameInfo game;
		
		try
		{
			// Opens connection
		
			DataInputStream inStream = new DataInputStream(new FileInputStream("Game("+gameNumber+").sav"));
			
			// ------------ Reads data -------------
			
			game = new GameInfo(inStream.readInt());					// Reads number of players, and creates new empty GameInfo
		
			for(int i = 0; i < game.getNumberOfPlayers(); i++)	
			{
				game.setPlayerNick(i, inStream.readUTF());				// Reads playerNicks
				game.setPlayerPW(i, inStream.readUTF());				// reads playerPWs
			}
			
			// Reads history			
			
			for(int i = 0; i < game.getNumberOfPlayers(); i++)			// For each player
				for(int i2 = 0; i2 < game.getNumberOfPlayers(); i2++) 	// For each player's enemy
					for(int i3 = 0; i3 < 2; i3++)						// For each history type
						game.setHistory(i, i2, i3, inStream.readInt());
			
			// Reads current turn information
			
			for(int i = 0; i < game.getNumberOfPlayers(); i++)
				for(int i2 = 0; i2 < 16; i2++)
					game.setCurrentTurnInformation(i, i2, inStream.readInt());

			// Reads orders
			
			for(int i = 0; i < game.getNumberOfPlayers(); i++)
				for (int i2 = 0; i2 < 3; i2++)
					game.setOrder(i, i2, inStream.readInt());
			
			inStream.close();
			
			System.out.println("When loading:");
			game.printGameInfo();
			
			return game;
		}
		catch(Exception err)
		{
			err.printStackTrace();
		}
		
		return null;
	}
	
	/**
	 * Starts a new game
	 * @param gameNumber - Index number of the game
	 **/
	
	public void startGame(int gameNumber, int numberOfPlayers, String [] playerNicks, String [] playerPW)
	{
		GameInfo newGame = new GameInfo(numberOfPlayers, playerNicks, playerPW);
		saveGame(gameNumber, newGame);
	}
	
	
	/**
	 * Loads game information from file, to check if nickname and password fits together
	 * SHOULD PROBABLY BE IN SOME OTHER FILE
	 **/
	 
	 public int login(int gameNumber, String playerNick, String playerPW)
	 {
	 	GameInfo game = loadGame(gameNumber);
	 	
	 	int playerIndex = game.findPlayer(playerNick);
	 	
	 	if(playerIndex < 0)			// If player doesn't exist
	 		return -1;
	 		
	 	if(playerPW.equals(game.getPlayerPW(playerIndex)))
	 		return playerIndex;
	 	
	 	return -1;
	 }
}